/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PICodeUpdate;
import com.ibm.hsc.cim.provider.pi.PIHscProviderConstants;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.BpaAcdlInfo;
import com.ibm.hsc.fsp.cmdhelpers.FruCode;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.frame.OmFrameMgr;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbemcfg.GlobalConfig;

public class FlashUtils {
    private static final String EXISTS_EXCPID = "3365";
    private static final String EXCP_READ_EXCPID = "3366";
    private static final String INVALID_EXCPID = "3385";
    private static final String NOTAFILE_EXCPID = "3372";
    private static final String ZEROSIZEFILE_EXCPID = "3373";
    private static final String NONEXISTINGFILE_EXCPID = "3374";
    private static final String EXCP_WRITE_EXCPID = "3375";
    private static final String INVALID_OPENTYPE_EXCPID = "3388";
    private static final String INVALID_FLAG_EXCPID = "3389";
    private static final String EXCP_OPEN_EXCPID = "3390";
    private static final String CODE_UPDATE_OWNER = "CodeUpdateOwner";
    private static final String CODE_UPDATE_STATUS = "CodeUpdateStatus";
    private static final String MOST_RECENT_HMC_NAME = "MostRecentHMCName";
    private static final String RETURN_CODE = "ReturnCode";
    private static final String TOTAL_FILE_SIZE = "TotalFileSize";
    private static final String WRITE_SIZE_LIMIT = "WriteSizeLimit";
    private static final String LAST_UPDATE_TYPE = "LastUpdateType";
    private static final String TIME_STAMP = "TimeStamp";
    private static final String KEYWORD_MI = "KeyWordMi";
    private static final String VRM = "Vrm";
    private static final String FAILURE_ERROR_CODE = "FailureErrorCode";
    private static final String TIME_LIMIT = "TimeLimit";
    private static final String TARGET_MASTER = "Master";
    private static final String TARGET_SLAVE = "Slave";

    protected static CIMValue startCodeUpdate(Vector vector, OmSysMgr omSysMgr, String string) throws PIHscServerException {
        String string2 = null;
        String string3 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.startCodeUpdate");
        try {
            UnsignedInt16 unsignedInt16;
            UnsignedInt8 unsignedInt8;
            if (GlobalConfig.callMethodsWithValues) {
                string2 = (String)((CIMValue)vector.elementAt(0)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector.elementAt(1)).getValue();
                unsignedInt16 = (UnsignedInt16)((CIMValue)vector.elementAt(2)).getValue();
            } else {
                string2 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                unsignedInt16 = (UnsignedInt16)((CIMProperty)vector.elementAt(2)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string2);
                string3 = FlashUtils.sendLocCode(string2);
                System.out.println("The locCode is :" + string3);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string3 = FlashUtils.getBpaLocCode(string2);
                System.out.println("The locCode is :" + string3);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            Trace.trace("apcuhscF", "The update side is :" + unsignedInt8);
            Trace.trace("apcuhscF", "The firmware component is :" + unsignedInt16);
            System.out.println("The update side is :" + unsignedInt8);
            System.out.println("The firmware component is :" + unsignedInt16);
            if (!PIHscProviderConstants.IPL_SIDE_P.equals((Object)unsignedInt8) && !PIHscProviderConstants.IPL_SIDE_T.equals((Object)unsignedInt8)) {
                Trace.trace("apcuhscT", "<- FlashUtils.startCodeUpdate");
                throw new PIHscServerException("01FC", null);
            }
            long l = fspCmdHelper.startCodeUpdate(string3, unsignedInt8, unsignedInt16);
            Trace.trace("apcuhscF", "The max write block size is :" + l);
            System.out.println("The max write block size is :" + l);
            String string4 = string.concat(string3);
            System.out.println("The name stored in the hashtable is :" + string4);
            PICodeUpdate.setMaxWBS(string4, l);
            Trace.trace("apcuhscT", "<- FlashUtils.startCodeUpdate");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.startCodeUpdate");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue beginCodeUpdate(Vector vector, OmCecMgr omCecMgr) throws PIHscServerException {
        int n = 192;
        Trace.trace("apcuhscT", "-> FlashUtils.beginCodeUpdate");
        try {
            String string = GlobalConfig.callMethodsWithValues ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            FlashUtils.checkFSPTarget(omCecMgr, string);
            FspLockHelper fspLockHelper = omCecMgr.getCodeUpdateLock();
            if (fspLockHelper != null) {
                System.out.println("The fsp lock from CEC Mgr is :" + fspLockHelper);
                throw new PIHscServerException("3398", null);
            }
            fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n);
            fspLockHelper.addCecLock(omCecMgr.getObjectId());
            fspLockHelper.lock();
            System.out.println("The Fsp lock is :" + fspLockHelper);
            omCecMgr.setCodeUpdateLock(fspLockHelper);
            Trace.trace("apcuhscT", "<- FlashUtils.beginCodeUpdate");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.beginCodeUpdate");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue endCodeUpdate(Vector vector, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("apcuhscT", "-> FlashUtils.beginCodeUpdate");
        try {
            String string = GlobalConfig.callMethodsWithValues ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            FlashUtils.checkFSPTarget(omCecMgr, string);
            FspLockHelper fspLockHelper = omCecMgr.getCodeUpdateLock();
            if (fspLockHelper == null) {
                throw new PIHscServerException("3399", null);
            }
            System.out.println("The fsp lock from CEC Mgr is :" + fspLockHelper);
            fspLockHelper.unlock();
            System.out.println("Clearing the lock in Cec Manager");
            fspLockHelper = null;
            omCecMgr.setCodeUpdateLock(fspLockHelper);
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.beginCodeUpdate");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue readLID(Vector vector, OmSysMgr omSysMgr) throws PIHscServerException {
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        String string3 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.readLID");
        try {
            Vector vector2;
            Vector vector3;
            String string4;
            if (GlobalConfig.callMethodsWithValues) {
                string4 = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector2 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
            } else {
                string4 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector2 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string4);
                string3 = FlashUtils.sendLocCode(string4);
                System.out.println("The locCode is :" + string3);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string3 = FlashUtils.getBpaLocCode(string4);
                System.out.println("The locCode is :" + string3);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (vector3.isEmpty() || vector2.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.readLID");
                throw new PIHscServerException("01FC", null);
            }
            if (vector3.size() != vector2.size()) {
                Trace.trace("apcuhscT", "<- FlashUtils.readLID");
                throw new PIHscServerException("3363", null);
            }
            for (int i = 0; i < vector2.size(); ++i) {
                String string5 = (String)vector2.elementAt(i);
                System.out.println("The file name is :" + string5);
                File file = new File(string5);
                if (file.exists()) {
                    if (!bl) {
                        bl = true;
                    }
                    string = string.concat(" ");
                    string = string.concat(string5);
                    continue;
                }
                file.createNewFile();
                try {
                    fspCmdHelper.readLID(string3, file, (UnsignedInt32)vector3.elementAt(i));
                    continue;
                }
                catch (Throwable throwable) {
                    Trace.trace("apcuhscT", "<- FlashUtils.readLID");
                    string2 = string2.concat(" ");
                    string2 = string2.concat(string5);
                    throwable.printStackTrace();
                    String string6 = "";
                    string6 = string6 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXCP_READ_EXCPID, null, new String[]{string2});
                    throw new PIHscServerException("3364", new String[]{string6}, null);
                }
            }
            if (bl) {
                String string7 = "";
                if (bl) {
                    string7 = HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXISTS_EXCPID, null, new String[]{string});
                }
                Trace.trace("apcuhscT", "<- FlashUtils.readLID");
                throw new PIHscServerException("3364", new String[]{string7}, null);
            }
            Trace.trace("apcuhscT", "<- FlashUtils.readLID");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.readLID");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue readLIDPartial(Vector vector, OmSysMgr omSysMgr) throws PIHscServerException {
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        String string3 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.readLIDPartial");
        try {
            Vector vector2;
            Vector vector3;
            Vector vector4;
            Vector vector5;
            String string4;
            if (GlobalConfig.callMethodsWithValues) {
                string4 = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector5 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
                vector2 = (Vector)((CIMValue)vector.elementAt(4)).getValue();
            } else {
                string4 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                vector2 = (Vector)((CIMProperty)vector.elementAt(4)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string4);
                string3 = FlashUtils.sendLocCode(string4);
                System.out.println("The locCode is :" + string3);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string3 = FlashUtils.getBpaLocCode(string4);
                System.out.println("The locCode is :" + string3);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (vector5.isEmpty() || vector4.isEmpty() || vector3.isEmpty() || vector2.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.readLIDPartial");
                throw new PIHscServerException("01FC", null);
            }
            if (vector5.size() != vector4.size() || vector5.size() != vector3.size() || vector5.size() != vector2.size()) {
                Trace.trace("apcuhscT", "<- FlashUtils.readLIDPartial");
                throw new PIHscServerException("3367", null);
            }
            for (int i = 0; i < vector4.size(); ++i) {
                String string5 = (String)vector4.elementAt(i);
                System.out.println("The file name is :" + string5);
                File file = new File(string5);
                if (file.exists()) {
                    if (!bl) {
                        bl = true;
                    }
                    string = string.concat(" ");
                    string = string.concat(string5);
                    continue;
                }
                file.createNewFile();
                try {
                    long l = ((UnsignedInt32)vector3.elementAt(i)).longValue();
                    long l2 = ((UnsignedInt32)vector2.elementAt(i)).longValue();
                    fspCmdHelper.readPartialLID(string3, file, (UnsignedInt32)vector5.elementAt(i), l, l2);
                    continue;
                }
                catch (Throwable throwable) {
                    string2 = string2.concat(" ");
                    string2 = string2.concat(string5);
                    throwable.printStackTrace();
                    String string6 = "";
                    string6 = string6 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXCP_READ_EXCPID, null, new String[]{string2});
                    Trace.trace("apcuhscT", "<- FlashUtils.readLIDPartial");
                    throw new PIHscServerException("3364", new String[]{string6}, null);
                }
            }
            if (bl || bl2) {
                String string7 = "";
                if (bl) {
                    string7 = HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXISTS_EXCPID, null, new String[]{string});
                }
                Trace.trace("apcuhscT", "<- FlashUtils.readLIDPartial");
                throw new PIHscServerException("3364", new String[]{string7}, null);
            }
            Trace.trace("apcuhscT", "<- FlashUtils.readLIDPartial");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.readLIDPartial");
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue writeLID(Vector vector, OmSysMgr omSysMgr, String string) throws PIHscServerException {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.writeLID");
        try {
            Vector vector2;
            Vector vector3;
            String string7;
            if (GlobalConfig.callMethodsWithValues) {
                string7 = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector2 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
            } else {
                string7 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector2 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string7);
                string6 = FlashUtils.sendLocCode(string7);
                System.out.println("The locCode is :" + string6);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string6 = FlashUtils.getBpaLocCode(string7);
                System.out.println("The locCode is :" + string6);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (vector3.isEmpty() || vector2.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.writeLID");
                throw new PIHscServerException("01FC", null);
            }
            if (vector3.size() != vector2.size()) {
                Trace.trace("apcuhscT", "<- FlashUtils.writeLID");
                throw new PIHscServerException("3363", null);
            }
            String string8 = string.concat(string6);
            System.out.println("The name after the concat is :" + string8);
            l = PICodeUpdate.getMaxWBS(string8);
            System.out.println("The max write block size is :" + l);
            for (int i = 0; i < vector2.size(); ++i) {
                String string9 = (String)vector2.elementAt(i);
                System.out.println("The file name is :" + string9);
                File file = new File(string9);
                if (file.exists()) {
                    if (!file.isFile()) {
                        if (!bl3) {
                            bl3 = true;
                        }
                        string4 = string4.concat(" ");
                        string4 = string4.concat(string9);
                        continue;
                    }
                    if (file.length() == 0L) {
                        if (!bl2) {
                            bl2 = true;
                        }
                        string3 = string3.concat(" ");
                        string3 = string3.concat(string9);
                        continue;
                    }
                } else {
                    if (!bl) {
                        bl = true;
                    }
                    string2 = string2.concat(" ");
                    string2 = string2.concat(string9);
                    continue;
                }
                try {
                    fspCmdHelper.writeLID(string6, file, (UnsignedInt32)vector3.elementAt(i), l);
                    continue;
                }
                catch (Throwable throwable) {
                    string5 = string5.concat(" ");
                    string5 = string5.concat(string9);
                    throwable.printStackTrace();
                    String string10 = "";
                    string10 = string10 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXCP_WRITE_EXCPID, null, new String[]{string5});
                    Trace.trace("apcuhscT", "<- FlashUtils.writeLID");
                    throw new PIHscServerException("3371", new String[]{string10}, null);
                }
            }
            if (bl3 || bl2 || bl) {
                String string11 = "";
                if (bl3) {
                    string11 = HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", NOTAFILE_EXCPID, null, new String[]{string4});
                }
                if (bl2) {
                    string11 = string11 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", ZEROSIZEFILE_EXCPID, null, new String[]{string3});
                }
                if (bl) {
                    string11 = string11 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", NONEXISTINGFILE_EXCPID, null, new String[]{string2});
                }
                Trace.trace("apcuhscT", "<- FlashUtils.writeLID");
                throw new PIHscServerException("3371", new String[]{string11}, null);
            }
            Trace.trace("apcuhscT", "<- FlashUtils.writeLID");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.writeLID");
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue writeLIDPartial(Vector vector, OmSysMgr omSysMgr) throws PIHscServerException {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.writeLIDPartial");
        try {
            Vector vector2;
            Vector vector3;
            Vector vector4;
            Vector vector5;
            String string7;
            if (GlobalConfig.callMethodsWithValues) {
                string7 = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector5 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
                vector2 = (Vector)((CIMValue)vector.elementAt(4)).getValue();
            } else {
                string7 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                vector2 = (Vector)((CIMProperty)vector.elementAt(4)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string7);
                string6 = FlashUtils.sendLocCode(string7);
                System.out.println("The locCode is :" + string6);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string6 = FlashUtils.getBpaLocCode(string7);
                System.out.println("The locCode is :" + string6);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (vector4.isEmpty() || vector3.isEmpty() || vector2.isEmpty() || vector5.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.writeLIDPartial");
                throw new PIHscServerException("01FC", null);
            }
            if (vector4.size() != vector3.size() || vector4.size() != vector5.size() || vector4.size() != vector2.size()) {
                Trace.trace("apcuhscT", "<- FlashUtils.writeLIDPartial");
                throw new PIHscServerException("3363", null);
            }
            for (int i = 0; i < vector3.size(); ++i) {
                String string8 = (String)vector3.elementAt(i);
                System.out.println("The file name is :" + string8);
                File file = new File(string8);
                if (file.exists()) {
                    if (!file.isFile()) {
                        if (!bl3) {
                            bl3 = true;
                        }
                        string3 = string3.concat(" ");
                        string3 = string3.concat(string8);
                        continue;
                    }
                    if (file.length() == 0L) {
                        if (!bl2) {
                            bl2 = true;
                        }
                        string2 = string2.concat(" ");
                        string2 = string2.concat(string8);
                        continue;
                    }
                } else {
                    if (!bl) {
                        bl = true;
                    }
                    string = string.concat(" ");
                    string = string.concat(string8);
                    continue;
                }
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector5.elementAt(i);
                if (!(PIHscProviderConstants.IPL_SIDE_P.equals((Object)unsignedInt8) || PIHscProviderConstants.IPL_SIDE_T.equals((Object)unsignedInt8) || PIHscProviderConstants.IPL_SIDE_BOTH.equals((Object)unsignedInt8))) {
                    if (!bl5) {
                        bl5 = true;
                    }
                    string5 = string5.concat(" ");
                    string5 = string5.concat(string8);
                    continue;
                }
                try {
                    fspCmdHelper.writeLIDPartial(string6, file, unsignedInt8, (UnsignedInt32)vector4.elementAt(i), ((UnsignedInt32)vector2.elementAt(i)).longValue());
                    continue;
                }
                catch (Throwable throwable) {
                    string4 = string4.concat(" ");
                    string4 = string4.concat(string8);
                    String string9 = "";
                    string9 = string9 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXCP_WRITE_EXCPID, null, new String[]{string4});
                    Trace.trace("apcuhscT", "<- FlashUtils.writeLIDPartial");
                    throw new PIHscServerException("3371", new String[]{string9}, null);
                }
            }
            if (bl3 || bl2 || bl || bl4 || bl5) {
                String string10 = "";
                if (bl3) {
                    string10 = HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", NOTAFILE_EXCPID, null, new String[]{string3});
                }
                if (bl2) {
                    string10 = string10 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", ZEROSIZEFILE_EXCPID, null, new String[]{string2});
                }
                if (bl) {
                    string10 = string10 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", NONEXISTINGFILE_EXCPID, null, new String[]{string});
                }
                if (bl5) {
                    string10 = string10 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", "3386", null, new String[]{string5});
                }
                Trace.trace("apcuhscT", "<- writeLIDPartial");
                throw new PIHscServerException("3371", new String[]{string10}, null);
            }
            Trace.trace("apcuhscT", "<- FlashUtils.writeLIDPartial");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.writeLIDPartial");
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue codeUpdateComplete(Vector vector, OmSysMgr omSysMgr, String string) throws PIHscServerException {
        String string2 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.codeUpdateComplete");
        try {
            UnsignedInt8 unsignedInt8;
            String string3;
            if (GlobalConfig.callMethodsWithValues) {
                string3 = (String)((CIMValue)vector.elementAt(0)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector.elementAt(1)).getValue();
            } else {
                string3 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string3);
                string2 = FlashUtils.sendLocCode(string3);
                System.out.println("The locCode is :" + string2);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string2 = FlashUtils.getBpaLocCode(string3);
                System.out.println("The locCode is :" + string2);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (!PIHscProviderConstants.COMPLETION_TYPE_ABORT.equals((Object)unsignedInt8) && !PIHscProviderConstants.COMPLETION_TYPE_NORMAL.equals((Object)unsignedInt8)) {
                Trace.trace("apcuhscT", "<- FlashUtils.codeUpdateComplete");
                throw new PIHscServerException("3381", null);
            }
            fspCmdHelper.completeCodeUpdate(string2, unsignedInt8);
            String string4 = string.concat(string2);
            System.out.println("The name stored in the hashtable is :" + string4);
            PICodeUpdate.deleteMaxWBS(string4);
            Trace.trace("apcuhscT", "<- FlashUtils.codeUpdateComplete");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.codeUpdateComplete");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue commitCodeUpdate(Vector vector, OmSysMgr omSysMgr) throws PIHscServerException {
        Object var4_2 = null;
        String string = null;
        Trace.trace("apcuhscT", "-> FlashUtils.commitCodeUpdate");
        try {
            UnsignedInt8 unsignedInt8;
            String string2;
            if (GlobalConfig.callMethodsWithValues) {
                string2 = (String)((CIMValue)vector.elementAt(0)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector.elementAt(1)).getValue();
            } else {
                string2 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string2);
                string = FlashUtils.sendLocCode(string2);
                System.out.println("The locCode is :" + string);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string = FlashUtils.getBpaLocCode(string2);
                System.out.println("The locCode is :" + string);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (!(PIHscProviderConstants.COPY_T_TO_P.equals((Object)unsignedInt8) || PIHscProviderConstants.COPY_P_TO_T.equals((Object)unsignedInt8) || PIHscProviderConstants.SWAP_P_TO_T.equals((Object)unsignedInt8))) {
                Trace.trace("apcuhscT", "<- FlashUtils.commitCodeUpdate");
                throw new PIHscServerException("01FC", null);
            }
            fspCmdHelper.commitCode(string, unsignedInt8);
            Trace.trace("apcuhscT", "<- FlashUtils.commitCodeUpdate");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.commitCodeUpdate");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue rebootSP(Vector vector, OmSysMgr omSysMgr) throws PIHscServerException {
        String string = null;
        Trace.trace("apcuhscT", "-> FlashUtils.rebootSP");
        try {
            String string2 = GlobalConfig.callMethodsWithValues ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string2);
                string = FlashUtils.sendLocCode(string2);
                System.out.println("The locCode is :" + string);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string = FlashUtils.getBpaLocCode(string2);
                System.out.println("The locCode is :" + string);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            fspCmdHelper.rebootSP(string);
            Trace.trace("apcuhscT", "<- FlashUtils.rebootSP");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.rebootSP");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue deleteLID(Vector vector, OmSysMgr omSysMgr, String string) throws PIHscServerException {
        boolean bl = false;
        String string2 = "";
        long l = 0L;
        String string3 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.deleteLID");
        try {
            Vector vector2;
            String string4;
            if (GlobalConfig.callMethodsWithValues) {
                string4 = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector2 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
            } else {
                string4 = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector2 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string4);
                string3 = FlashUtils.sendLocCode(string4);
                System.out.println("The locCode is :" + string3);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string3 = FlashUtils.getBpaLocCode(string4);
                System.out.println("The locCode is :" + string3);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (vector2.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.deleteLID");
                throw new PIHscServerException("01FC", null);
            }
            String string5 = string.concat(string3);
            l = PICodeUpdate.getMaxWBS(string5);
            for (int i = 0; i < vector2.size(); ++i) {
                try {
                    fspCmdHelper.deleteLID(string3, (UnsignedInt32)vector2.elementAt(i));
                    continue;
                }
                catch (Throwable throwable) {
                    string2 = string2.concat(" ");
                    string2 = string2.concat(((UnsignedInt32)vector2.elementAt(i)).toString());
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                    Trace.trace("apcuhscT", "<- FlashUtils.deleteLID");
                    throw new PIHscServerException("3370", new String[]{string2}, null);
                }
            }
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.deleteLID");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue setCodeUpdateOwner(Vector vector, OmSysMgr omSysMgr) throws PIHscServerException {
        Object var4_2 = null;
        String string = null;
        Trace.trace("apcuhscT", "-> FlashUtils.setCodeUpdateOwner");
        try {
            UnsignedInt8 unsignedInt8;
            String string2;
            if (GlobalConfig.callMethodsWithValues) {
                string2 = (String)((CIMValue)vector.elementAt(0)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector.elementAt(1)).getValue();
            } else {
                string2 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string2);
                string = FlashUtils.sendLocCode(string2);
                System.out.println("The locCode is :" + string);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string = FlashUtils.getBpaLocCode(string2);
                System.out.println("The locCode is :" + string);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (PIHscProviderConstants.HMC_IS_OWNER.equals((Object)unsignedInt8) && PIHscProviderConstants.HMC_IS_HYPER.equals((Object)unsignedInt8)) {
                Trace.trace("apcuhscT", "<- FlashUtils.setCodeUpdateOwner");
                throw new PIHscServerException("01FC", null);
            }
            fspCmdHelper.setCodeUpdatePolicy(string, unsignedInt8);
            Trace.trace("apcuhscT", "<- FlashUtils.setCodeUpdateOwner");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.setCodeUpdateOwner");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue getCodeUpdateStatus(Vector vector, OmSysMgr omSysMgr, Vector vector2) throws PIHscServerException {
        Hashtable hashtable = null;
        String string = null;
        String string2 = null;
        vector2.setSize(3);
        Trace.trace("apcuhscT", "-> FlashUtils.getCodeUpdateStatus");
        try {
            String string3 = GlobalConfig.callMethodsWithValues ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string3);
                string2 = FlashUtils.sendLocCode(string3);
                System.out.println("The locCode is :" + string2);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string2 = FlashUtils.getBpaLocCode(string3);
                System.out.println("The locCode is :" + string2);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            hashtable = fspCmdHelper.getCodeUpdateStatus(string2);
            if (hashtable != null) {
                byte[] byArray = (byte[])hashtable.get("NAME");
                string = byArray.length == 0 ? "$$Not$$Set$$" : new String(byArray).trim();
                if (GlobalConfig.callMethodsWithValues) {
                    vector2.setElementAt(new CIMValue((Object)((UnsignedInt8)hashtable.get("UPDATE_POLICY"))), 0);
                    vector2.setElementAt(new CIMValue((Object)((UnsignedInt8)hashtable.get("UPDATE_STATUS"))), 1);
                    vector2.setElementAt(new CIMValue((Object)string), 2);
                } else {
                    vector2.setElementAt(new CIMProperty(CODE_UPDATE_OWNER, new CIMValue((Object)((UnsignedInt8)hashtable.get("UPDATE_POLICY")))), 0);
                    vector2.setElementAt(new CIMProperty(CODE_UPDATE_STATUS, new CIMValue((Object)((UnsignedInt8)hashtable.get("UPDATE_STATUS")))), 1);
                    vector2.setElementAt(new CIMProperty(MOST_RECENT_HMC_NAME, new CIMValue((Object)string)), 2);
                }
            }
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.getCodeUpdateStatus");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue readSpecialLID(Vector vector, OmSysMgr omSysMgr) throws PIHscServerException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.readSpecialLID");
        try {
            Vector vector2;
            Vector vector3;
            Vector vector4;
            Vector vector5;
            Vector vector6;
            String string5;
            if (GlobalConfig.callMethodsWithValues) {
                string5 = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector6 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector5 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
                vector3 = (Vector)((CIMValue)vector.elementAt(4)).getValue();
                vector2 = (Vector)((CIMValue)vector.elementAt(5)).getValue();
            } else {
                string5 = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                vector3 = (Vector)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                vector2 = (Vector)((CIMProperty)vector.elementAt(5)).getValue().getValue();
            }
            if (omSysMgr instanceof OmCecMgr) {
                System.out.println("Is a Cec object, hence check for master slave FSP");
                FlashUtils.checkFSPTarget(omSysMgr, string5);
                string4 = FlashUtils.sendLocCode(string5);
                System.out.println("The locCode is :" + string4);
            } else if (omSysMgr instanceof OmFrameMgr) {
                System.out.println("Is a Frame object ");
                string4 = FlashUtils.getBpaLocCode(string5);
                System.out.println("The locCode is :" + string4);
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            if (vector6.isEmpty() || vector4.isEmpty() || vector3.isEmpty() || vector2.isEmpty() || vector5.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.readSpecialLID");
                throw new PIHscServerException("01FC", null);
            }
            if (vector6.size() != vector4.size() || vector6.size() != vector3.size() || vector6.size() != vector5.size() || vector6.size() != vector2.size()) {
                Trace.trace("apcuhscT", "<- FlashUtils.readSpecialLID");
                throw new PIHscServerException("3367", null);
            }
            for (int i = 0; i < vector4.size(); ++i) {
                String string6 = (String)vector4.elementAt(i);
                System.out.println("The file name is :" + string6);
                File file = new File(string6);
                if (file.exists()) {
                    if (!bl) {
                        bl = true;
                        System.out.println("The file exists");
                    }
                    string = string.concat(" ");
                    string = string.concat(string6);
                    continue;
                }
                file.createNewFile();
                try {
                    long l = ((UnsignedInt32)vector3.elementAt(i)).longValue();
                    long l2 = ((UnsignedInt32)vector2.elementAt(i)).longValue();
                    UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector5.elementAt(i);
                    Trace.trace("apcuhscF", "The offset is :" + l);
                    Trace.trace("apcuhscF", "The length is : " + l2);
                    Trace.trace("apcuhscF", " The code side is : " + unsignedInt8);
                    System.out.println("The offset is :" + l);
                    System.out.println("The length is : " + l2);
                    System.out.println(" The code side is : " + unsignedInt8);
                    if (!PIHscProviderConstants.IPL_SIDE_P.equals((Object)unsignedInt8) && !PIHscProviderConstants.IPL_SIDE_T.equals((Object)unsignedInt8)) {
                        if (!bl3) {
                            bl3 = true;
                            System.out.println("Invalid data flag for the IPL side");
                        }
                        string3 = string3.concat(" ");
                        string3 = string3.concat(string6);
                        continue;
                    }
                    UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector6.elementAt(i);
                    System.out.println("The special LID id is " + unsignedInt16);
                    if (!PIHscProviderConstants.MASTER_LID.equals((Object)unsignedInt16) && !PIHscProviderConstants.MARKER_LID.equals((Object)unsignedInt16)) {
                        if (!bl3) {
                            bl3 = true;
                            System.out.println("Invalid data flag for LID Master/Marker");
                        }
                        string3 = string3.concat(" ");
                        string3 = string3.concat(string6);
                        continue;
                    }
                    System.out.println("Sending down the command");
                    fspCmdHelper.readSpecialLID(string4, file, unsignedInt16, unsignedInt8, l, l2);
                    continue;
                }
                catch (Throwable throwable) {
                    string2 = string2.concat(" ");
                    string2 = string2.concat(string6);
                    throwable.printStackTrace();
                    String string7 = "";
                    string7 = string7 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXCP_READ_EXCPID, null, new String[]{string2});
                    Trace.trace("apcuhscT", "<- FlashUtils.readSpecialLID");
                    throw new PIHscServerException("3364", new String[]{string7}, null);
                }
            }
            if (bl || bl2 || bl3) {
                String string8 = "";
                if (bl) {
                    string8 = HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXISTS_EXCPID, null, new String[]{string});
                }
                if (bl3) {
                    string8 = string8 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", INVALID_EXCPID, null, new String[]{string3});
                }
                Trace.trace("apcuhscT", "<- FlashUtils.readSpecialLID");
                throw new PIHscServerException("3364", new String[]{string8}, null);
            }
            Trace.trace("apcuhscT", "<- FlashUtils.readSpecialLID");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.readSpecialLID");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue openPhypFile(Vector vector, OmCecMgr omCecMgr, Vector vector2) throws PIHscServerException {
        Hashtable hashtable = null;
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        Vector<UnsignedInt32> vector4 = new Vector<UnsignedInt32>();
        Vector<UnsignedInt32> vector5 = new Vector<UnsignedInt32>();
        Trace.trace("apcuhscT", "-> FlashUtils.openPhypFile");
        System.out.println("In openPhypFile --- FlashUtils");
        try {
            Vector vector6;
            Vector vector7;
            Vector vector8;
            Vector vector9;
            Vector vector10;
            Vector vector11;
            String string;
            if (GlobalConfig.callMethodsWithValues) {
                string = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector11 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector10 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                vector9 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
                vector8 = (Vector)((CIMValue)vector.elementAt(4)).getValue();
                vector7 = (Vector)((CIMValue)vector.elementAt(5)).getValue();
                vector6 = (Vector)((CIMValue)vector.elementAt(6)).getValue();
            } else {
                string = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector11 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector10 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                vector9 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                vector8 = (Vector)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                vector7 = (Vector)((CIMProperty)vector.elementAt(5)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector.elementAt(6)).getValue().getValue();
            }
            FlashUtils.checkFSPTarget(omCecMgr, string);
            FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
            if (vector11.isEmpty() || vector10.isEmpty() || vector9.isEmpty() || vector8.isEmpty() || vector7.isEmpty() || vector6.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.openPhypFile");
                throw new PIHscServerException("01FC", null);
            }
            if (vector11.size() != vector10.size() || vector11.size() != vector9.size() || vector11.size() != vector8.size() || vector11.size() != vector7.size() || vector11.size() != vector6.size()) {
                Trace.trace("apcuhscT", "<- FlashUtils.openPhypFile");
                throw new PIHscServerException("3367", null);
            }
            for (int i = 0; i < vector11.size(); ++i) {
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector11.elementAt(i);
                UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector10.elementAt(i);
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector9.elementAt(i);
                Trace.trace("apcuhscF", "The file ID is :" + unsignedInt16);
                Trace.trace("apcuhscF", "The file sub ID is :" + unsignedInt32);
                Trace.trace("apcuhscF", "The open type is :" + unsignedInt8);
                System.out.println("The file ID is :" + unsignedInt16);
                System.out.println("The file sub ID is :" + unsignedInt32);
                System.out.println("The open type is :" + unsignedInt8);
                if (!(PIHscProviderConstants.OPEN_READ.equals((Object)unsignedInt8) || PIHscProviderConstants.OPEN_WRITE.equals((Object)unsignedInt8) || PIHscProviderConstants.OPEN_CREATE.equals((Object)unsignedInt8))) {
                    vector3.addElement(new UnsignedInt16(17));
                    vector4.addElement(new UnsignedInt32(0L));
                    vector5.addElement(new UnsignedInt32(0L));
                    continue;
                }
                UnsignedInt8 unsignedInt82 = (UnsignedInt8)vector8.elementAt(i);
                if (PIHscProviderConstants.FLAG_FORCE.equals((Object)unsignedInt82) && !PIHscProviderConstants.OPEN_WRITE.equals((Object)unsignedInt8) && !PIHscProviderConstants.OPEN_CREATE.equals((Object)unsignedInt8)) {
                    vector3.addElement(new UnsignedInt16(18));
                    vector4.addElement(new UnsignedInt32(0L));
                    vector5.addElement(new UnsignedInt32(0L));
                    continue;
                }
                UnsignedInt32 unsignedInt322 = (UnsignedInt32)vector7.elementAt(i);
                UnsignedInt32 unsignedInt323 = (UnsignedInt32)vector6.elementAt(i);
                hashtable = null;
                try {
                    hashtable = fspCmdHelper.openPhypFile(string, unsignedInt16, unsignedInt32, unsignedInt8, unsignedInt82, unsignedInt322, unsignedInt323);
                    vector3.addElement((UnsignedInt16)hashtable.get("RETURN_CODE"));
                    vector4.addElement((UnsignedInt32)hashtable.get("TOTAL_FILE_SIZE"));
                    vector5.addElement((UnsignedInt32)hashtable.get("WRITE_SIZE_LIMIT"));
                    continue;
                }
                catch (Throwable throwable) {
                    vector3.addElement(new UnsignedInt16(19));
                    vector4.addElement(new UnsignedInt32(0L));
                    vector5.addElement(new UnsignedInt32(0L));
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
            }
            if (vector2.size() == 0) {
                vector2.setSize(3);
            }
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue(vector3, new CIMDataType(23)), 0);
                vector2.setElementAt(new CIMValue(vector4, new CIMDataType(25)), 1);
                vector2.setElementAt(new CIMValue(vector5, new CIMDataType(25)), 2);
            } else {
                vector2.setElementAt(new CIMProperty(RETURN_CODE, new CIMValue(vector3, new CIMDataType(23))), 0);
                vector2.setElementAt(new CIMProperty(TOTAL_FILE_SIZE, new CIMValue(vector4, new CIMDataType(25))), 1);
                vector2.setElementAt(new CIMProperty(WRITE_SIZE_LIMIT, new CIMValue(vector5, new CIMDataType(25))), 2);
            }
            Trace.trace("apcuhscT", "<- FlashUtils.openPhypFile");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.openPhypFile");
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue writePhypFile(Vector vector, OmCecMgr omCecMgr, Vector vector2) throws PIHscServerException {
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        System.out.println("In writePhypefile --- flashUtils");
        Trace.trace("apcuhscT", "-> FlashUtils.writePhypFile");
        try {
            Vector vector4;
            Vector vector5;
            Vector vector6;
            Vector vector7;
            Vector vector8;
            String string;
            if (GlobalConfig.callMethodsWithValues) {
                string = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector8 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector7 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                vector6 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
                vector5 = (Vector)((CIMValue)vector.elementAt(4)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(5)).getValue();
            } else {
                string = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector8 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector7 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector.elementAt(4)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(5)).getValue().getValue();
            }
            FlashUtils.checkFSPTarget(omCecMgr, string);
            FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
            if (vector8.isEmpty() || vector7.isEmpty() || vector7.isEmpty() || vector5.isEmpty() || vector4.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.writePhypFile");
                throw new PIHscServerException("01FC", null);
            }
            if (vector8.size() != vector7.size() || vector8.size() != vector6.size() || vector8.size() != vector5.size() || vector8.size() != vector4.size()) {
                Trace.trace("apcuhscT", "<- FlashUtils.writePhypFile");
                throw new PIHscServerException("3367", null);
            }
            for (int i = 0; i < vector8.size(); ++i) {
                String string2 = (String)vector4.elementAt(i);
                File file = new File(string2);
                System.out.println("The lid file name is :" + string2);
                if (file.exists()) {
                    if (!file.isFile()) {
                        vector3.addElement(new UnsignedInt16(20));
                        continue;
                    }
                    if (file.length() == 0L) {
                        vector3.addElement(new UnsignedInt16(21));
                        continue;
                    }
                } else {
                    vector3.addElement(new UnsignedInt16(22));
                    continue;
                }
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector8.elementAt(i);
                UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector7.elementAt(i);
                UnsignedInt32 unsignedInt322 = (UnsignedInt32)vector6.elementAt(i);
                UnsignedInt32 unsignedInt323 = (UnsignedInt32)vector5.elementAt(i);
                Trace.trace("apcuhscF", "The file id is :" + unsignedInt16);
                Trace.trace("apcuhscF", "The file sub id is :" + unsignedInt32);
                Trace.trace("apcuhscF", "The file offset is :" + unsignedInt322);
                Trace.trace("apcuhscF", "The length to write is :" + unsignedInt323);
                System.out.println("The file id is :" + unsignedInt16);
                System.out.println("The file sub id is :" + unsignedInt32);
                System.out.println("The file offset is :" + unsignedInt322);
                System.out.println("The length to write is :" + unsignedInt323);
                try {
                    UnsignedInt16 unsignedInt162 = fspCmdHelper.writePhypFile(string, unsignedInt16, unsignedInt32, unsignedInt322, unsignedInt323, file);
                    vector3.addElement(unsignedInt162);
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    String string3 = "";
                    string3 = string3.concat(unsignedInt16.toString());
                    string3 = string3.concat(" ");
                    string3 = string3.concat(unsignedInt32.toString());
                    String string4 = "";
                    string4 = string4 + HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", EXCP_WRITE_EXCPID, null, new String[]{string3});
                    Trace.trace("apcuhscT", "<- FlashUtils.writePhypFile");
                    throw new PIHscServerException("3371", new String[]{string4}, null);
                }
            }
            if (vector2.size() == 0) {
                vector2.setSize(1);
            }
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue(vector3, new CIMDataType(23)), 0);
            } else {
                vector2.setElementAt(new CIMProperty(RETURN_CODE, new CIMValue(vector3, new CIMDataType(23))), 0);
            }
            Trace.trace("apcuhscT", "<- FlashUtils.writePhypFile");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.writePhypFile");
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue closePhypFile(Vector vector, OmCecMgr omCecMgr, Vector vector2) throws PIHscServerException {
        Hashtable hashtable = null;
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        System.out.println("In close phyp file#######");
        Trace.trace("apcuhscT", "-> FlashUtils.closePhypFile");
        try {
            Vector vector4;
            Vector vector5;
            Vector vector6;
            String string;
            if (GlobalConfig.callMethodsWithValues) {
                string = (String)((CIMValue)vector.elementAt(0)).getValue();
                vector6 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                vector5 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
                vector4 = (Vector)((CIMValue)vector.elementAt(3)).getValue();
            } else {
                string = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
            }
            FlashUtils.checkFSPTarget(omCecMgr, string);
            FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
            if (vector6.isEmpty() || vector5.isEmpty() || vector4.isEmpty()) {
                Trace.trace("apcuhscT", "<- FlashUtils.closePhypFile");
                throw new PIHscServerException("01FC", null);
            }
            if (vector6.size() != vector5.size() || vector6.size() != vector4.size()) {
                Trace.trace("apcuhscT", "<- FlashUtils.closePhypFile");
                throw new PIHscServerException("3367", null);
            }
            for (int i = 0; i < vector6.size(); ++i) {
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)vector6.elementAt(i);
                UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector5.elementAt(i);
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector4.elementAt(i);
                if (!(PIHscProviderConstants.COMMIT_PENDING_UPDATES.equals((Object)unsignedInt8) || PIHscProviderConstants.CLOSE_FOR_READ.equals((Object)unsignedInt8) || PIHscProviderConstants.DISCARD_PENDING_UPDATES.equals((Object)unsignedInt8))) {
                    vector3.addElement(new UnsignedInt16(23));
                    continue;
                }
                hashtable = null;
                try {
                    hashtable = fspCmdHelper.closePhypFile(string, unsignedInt16, unsignedInt32, unsignedInt8);
                    vector3.addElement((UnsignedInt16)hashtable.get("RETURN_CODE"));
                    continue;
                }
                catch (Throwable throwable) {
                    vector3.addElement(new UnsignedInt16(19));
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
            }
            if (vector2.size() == 0) {
                vector2.setSize(1);
            }
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue(vector3, new CIMDataType(23)), 0);
            } else {
                vector2.setElementAt(new CIMProperty(RETURN_CODE, new CIMValue(vector3, new CIMDataType(23))), 0);
            }
            Trace.trace("apcuhscT", "<- FlashUtils.closePhypFile");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.closePhypFile");
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue getFirmUpdateStatus(Vector vector, OmCecMgr omCecMgr, Vector vector2) throws PIHscServerException {
        Hashtable hashtable = null;
        Object var4_4 = null;
        Trace.trace("apcuhscT", "-> FlashUtils.getCodeUpdateStatus");
        try {
            String string = GlobalConfig.callMethodsWithValues ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            FlashUtils.checkFSPTarget(omCecMgr, string);
            FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
            hashtable = fspCmdHelper.getPhypUpdateStatus(string);
            System.out.println("The return Hash is :" + hashtable);
            if (vector2.size() == 0) {
                vector2.setSize(8);
            }
            byte[] byArray = (byte[])hashtable.get("TIME_STAMP");
            String string2 = ByteUtilities.toHexString(byArray);
            String string3 = ((String)hashtable.get("MI_KEYWORD")).trim();
            if (string3 == null || string3.length() == 0) {
                string3 = "0";
            }
            System.out.println("The miKey is :" + string3);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)((UnsignedInt16)hashtable.get("RETURN_CODE"))), 0);
                vector2.setElementAt(new CIMValue((Object)((UnsignedInt8)hashtable.get("UPDATE_STATUS"))), 1);
                vector2.setElementAt(new CIMValue((Object)((UnsignedInt8)hashtable.get("LAST_UPDATE_TYPE"))), 2);
                vector2.setElementAt(new CIMValue((Object)string2), 3);
                vector2.setElementAt(new CIMValue((Object)string3), 4);
                vector2.setElementAt(new CIMValue((Object)((UnsignedInt64)hashtable.get("VRM"))), 5);
                vector2.setElementAt(new CIMValue((Object)((UnsignedInt8)hashtable.get("ERROR_CODE"))), 6);
                vector2.setElementAt(new CIMValue((Object)((UnsignedInt16)hashtable.get("TIME_LIMIT"))), 7);
            } else {
                vector2.setElementAt(new CIMProperty(RETURN_CODE, new CIMValue((Object)((UnsignedInt16)hashtable.get("RETURN_CODE")))), 0);
                vector2.setElementAt(new CIMProperty(CODE_UPDATE_STATUS, new CIMValue((Object)((UnsignedInt8)hashtable.get("UPDATE_STATUS")))), 1);
                vector2.setElementAt(new CIMProperty(LAST_UPDATE_TYPE, new CIMValue((Object)((UnsignedInt8)hashtable.get("LAST_UPDATE_TYPE")))), 2);
                vector2.setElementAt(new CIMProperty(TIME_STAMP, new CIMValue((Object)string2)), 3);
                vector2.setElementAt(new CIMProperty(KEYWORD_MI, new CIMValue((Object)string3)), 4);
                vector2.setElementAt(new CIMProperty(VRM, new CIMValue((Object)((UnsignedInt64)hashtable.get("VRM")))), 5);
                vector2.setElementAt(new CIMProperty(FAILURE_ERROR_CODE, new CIMValue((Object)((UnsignedInt8)hashtable.get("ERROR_CODE")))), 6);
                vector2.setElementAt(new CIMProperty(TIME_LIMIT, new CIMValue((Object)((UnsignedInt16)hashtable.get("TIME_LIMIT")))), 7);
            }
            System.out.println("The out vector is :" + vector2);
            Trace.trace("apcuhscT", "<- FlashUtils.getCodeUpdateStatus");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.getCodeUpdateStatus");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue startFirmUpdate(Vector vector, OmCecMgr omCecMgr, Vector vector2) throws PIHscServerException {
        Hashtable hashtable = null;
        Vector vector3 = new Vector();
        Trace.trace("apcuhscT", "-> FlashUtils.startFirmUpdate");
        System.out.println("In Start Firmware Update");
        try {
            UnsignedInt16 unsignedInt16;
            UnsignedInt8 unsignedInt8;
            String string;
            if (GlobalConfig.callMethodsWithValues) {
                string = (String)((CIMValue)vector.elementAt(0)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector.elementAt(1)).getValue();
                unsignedInt16 = (UnsignedInt16)((CIMValue)vector.elementAt(2)).getValue();
            } else {
                string = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                unsignedInt16 = (UnsignedInt16)((CIMProperty)vector.elementAt(2)).getValue().getValue();
            }
            FlashUtils.checkFSPTarget(omCecMgr, string);
            FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
            if (vector2.size() == 0) {
                vector2.setSize(1);
            }
            if (!(PIHscProviderConstants.REMOVE_PHYP_CLEAR.equals((Object)unsignedInt8) || PIHscProviderConstants.APPLY_PHYP_CLEAR.equals((Object)unsignedInt8) || PIHscProviderConstants.REMOVE_PHYP_ONLY.equals((Object)unsignedInt8) || PIHscProviderConstants.APPLY_PHYP_ONLY.equals((Object)unsignedInt8) || PIHscProviderConstants.CLEAR_PFW_CACHE.equals((Object)unsignedInt8))) {
                FlashUtils.updateParams(new UnsignedInt16(24), vector2);
                Trace.trace("apcuhscT", "<- FlashUtils.startFirmUpdate");
                return new CIMValue((Object)new UnsignedInt8(1));
            }
            hashtable = null;
            try {
                hashtable = fspCmdHelper.startFirmwareUpdate(string, unsignedInt8, unsignedInt16);
                FlashUtils.updateParams((UnsignedInt16)hashtable.get("RETURN_CODE"), vector2);
            }
            catch (Throwable throwable) {
                FlashUtils.updateParams(new UnsignedInt16(19), vector2);
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                Trace.trace("apcuhscT", "<- FlashUtils.startFirmUpdate");
                return new CIMValue((Object)new UnsignedInt8(1));
            }
            System.out.println("The outparams is :" + vector2);
            Trace.trace("apcuhscT", "<- FlashUtils.startFirmUpdate");
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.startFirmUpdate");
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static void updateParams(UnsignedInt16 unsignedInt16, Vector vector) {
        if (GlobalConfig.callMethodsWithValues) {
            vector.setElementAt(new CIMValue((Object)unsignedInt16), 0);
        } else {
            vector.setElementAt(new CIMProperty(RETURN_CODE, new CIMValue((Object)unsignedInt16)), 0);
        }
    }

    protected static void checkFSPTarget(OmSysMgr omSysMgr, String string) throws PIHscServerException, RException {
        RObject rObject = null;
        rObject = omSysMgr.getObject();
        System.out.println("The R cec instance is : " + rObject);
        boolean bl = (Boolean)rObject.getProperty(R50ComputerSystem.Index_SlaveFSPExists);
        System.out.println("The slave FSP flag in cec is:" + bl);
        System.out.println("The Target is :" + string);
        if (TARGET_SLAVE.equalsIgnoreCase(string.trim()) && !bl) {
            throw new PIHscServerException("3397", null);
        }
    }

    protected static String sendLocCode(String string) throws PIHscServerException {
        String string2 = null;
        if (TARGET_SLAVE.equalsIgnoreCase(string.trim())) {
            string2 = "SECONDARY";
        } else if (TARGET_MASTER.equalsIgnoreCase(string.trim())) {
            string2 = "PRIMARY";
        } else {
            System.out.println("Invalid FSP target specified");
            throw new PIHscServerException("3400", null);
        }
        return string2;
    }

    protected static String getBpaLocCode(String string) throws PIHscServerException {
        String string2 = null;
        if ("SIDE_A".equalsIgnoreCase(string.trim())) {
            string2 = "SIDE_A";
        } else if ("SIDE_B".equalsIgnoreCase(string.trim())) {
            string2 = "SIDE_B";
        } else {
            System.out.println("Invalid FSP target specified");
            throw new PIHscServerException("A101", null);
        }
        return string2;
    }

    protected static CIMValue startACDL(Vector vector, OmSysMgr omSysMgr, Vector vector2) throws PIHscServerException {
        Trace.trace("apcuhscT", "-> FlashUtils.startACDL");
        try {
            String string = GlobalConfig.callMethodsWithValues ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            if (omSysMgr instanceof OmFrameMgr) {
                // empty if block
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt82 = new UnsignedInt8(0);
            try {
                unsignedInt8 = fspCmdHelper.startACDL(string);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                System.out.println("**Error - start ACDL");
                pIHscCmdMgrException.printStackTrace();
                String string2 = pIHscCmdMgrException.getHscExId();
                int n = pIHscCmdMgrException.getStatus();
                System.out.println("The ex id value is :" + string2);
                System.out.println("status value: " + n);
                if (string2.equals("1400") && n == 0) {
                    throw pIHscCmdMgrException;
                }
                if (6 == n) {
                    byte[] byArray = pIHscCmdMgrException.getMessagePayload();
                    try {
                        Hashtable hashtable = PIParseResponse.parseByCmd("BPA_DEACTIVATE_FRU_ERR", byArray);
                        unsignedInt8 = (UnsignedInt8)hashtable.get("RETURN_CODE");
                        unsignedInt82 = (UnsignedInt8)hashtable.get("ERROR_DATA");
                    }
                    catch (IOException iOException) {
                        System.out.println("!!!Error while parsing error data...");
                        iOException.printStackTrace();
                        unsignedInt8 = new UnsignedInt8((short)n);
                    }
                }
                unsignedInt8 = new UnsignedInt8((short)n);
            }
            if (vector2.size() == 0) {
                vector2.setSize(2);
            }
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt8), 0);
                vector2.setElementAt(new CIMValue((Object)unsignedInt82), 1);
            } else {
                vector2.setElementAt(new CIMProperty(RETURN_CODE, new CIMValue((Object)unsignedInt8)), 0);
                vector2.setElementAt(new CIMProperty("ErrorData", new CIMValue((Object)unsignedInt82)), 1);
            }
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.startACDL");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }

    protected static CIMValue getACDLStatus(Vector vector, OmSysMgr omSysMgr, Vector vector2) throws PIHscServerException {
        Trace.trace("apcuhscT", "-> FlashUtils.getACDLStatus");
        System.out.println("-> FlashUtils.getACDLStatus");
        try {
            String string = GlobalConfig.callMethodsWithValues ? (String)((CIMValue)vector.elementAt(0)).getValue() : (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            if (omSysMgr instanceof OmFrameMgr) {
                // empty if block
            }
            FspCmdHelper fspCmdHelper = omSysMgr.getCmdHelper();
            UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt82 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt83 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt84 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt85 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt86 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt87 = new UnsignedInt8(0);
            Object var12_13 = null;
            Vector<String> vector3 = new Vector<String>();
            Vector<UnsignedInt8> vector4 = new Vector<UnsignedInt8>();
            Vector<UnsignedInt16> vector5 = new Vector<UnsignedInt16>();
            Vector<UnsignedInt16> vector6 = new Vector<UnsignedInt16>();
            Vector<UnsignedInt16> vector7 = new Vector<UnsignedInt16>();
            Vector<UnsignedInt16> vector8 = new Vector<UnsignedInt16>();
            try {
                System.out.println("Send down the getACDLstatus command");
                BpaAcdlInfo bpaAcdlInfo = fspCmdHelper.getAcdlInfo(string);
                System.out.println("Received the response");
                unsignedInt8 = bpaAcdlInfo.getReturnCode();
                System.out.println("The return code is " + unsignedInt8);
                unsignedInt83 = bpaAcdlInfo.getBpaSide();
                System.out.println("The bpa side is :" + unsignedInt83);
                unsignedInt84 = bpaAcdlInfo.getSystemStatusMode();
                System.out.println("The status mode is :" + unsignedInt84);
                unsignedInt85 = bpaAcdlInfo.getSystemStatusProgress();
                System.out.println("The status progress is :" + unsignedInt85);
                unsignedInt86 = bpaAcdlInfo.getNoOfFruCompleted();
                System.out.println("The frus completed is :" + unsignedInt86);
                unsignedInt87 = bpaAcdlInfo.getNoOfFruToLoad();
                System.out.println("The frus to load is :" + unsignedInt87);
                FruCode[] fruCodeArray = bpaAcdlInfo.getFruList();
                System.out.println("The number of fru's is :" + fruCodeArray.length);
                for (int i = 0; i < fruCodeArray.length; ++i) {
                    FruCode fruCode = fruCodeArray[i];
                    System.out.println("The location code is : " + fruCode.getLocCode());
                    vector3.addElement(fruCode.getLocCode());
                    System.out.println("The Fru Status is :" + fruCode.getFruStatus());
                    vector4.addElement(fruCode.getFruStatus());
                    System.out.println("The Actual code is :" + fruCode.getActualCodeLevel());
                    vector5.addElement(fruCode.getActualCodeLevel());
                    System.out.println("The expected code is :" + fruCode.getExpectedCodeLevel());
                    vector6.addElement(fruCode.getExpectedCodeLevel());
                    if (fruCode.getActualCodeLevel1() == null) {
                        vector7.addElement(new UnsignedInt16(0));
                    } else {
                        System.out.println("The Actual code is :" + fruCode.getActualCodeLevel1());
                        vector7.addElement(fruCode.getActualCodeLevel1());
                    }
                    if (fruCode.getExpectedCodeLevel1() == null) {
                        vector8.addElement(new UnsignedInt16(0));
                        continue;
                    }
                    System.out.println("The expected code is :" + fruCode.getExpectedCodeLevel1());
                    vector8.addElement(fruCode.getExpectedCodeLevel1());
                }
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                System.out.println("**Error - start ACDL");
                pIHscCmdMgrException.printStackTrace();
                int n = pIHscCmdMgrException.getStatus();
                System.out.println("status value: " + n);
                if (6 == n) {
                    byte[] byArray = pIHscCmdMgrException.getMessagePayload();
                    try {
                        Hashtable hashtable = PIParseResponse.parseByCmd("BPA_DEACTIVATE_FRU_ERR", byArray);
                        unsignedInt8 = (UnsignedInt8)hashtable.get("RETURN_CODE");
                        unsignedInt82 = (UnsignedInt8)hashtable.get("ERROR_DATA");
                    }
                    catch (IOException iOException) {
                        System.out.println("!!!Error while parsing error data...");
                        iOException.printStackTrace();
                        unsignedInt8 = new UnsignedInt8((short)n);
                    }
                }
                unsignedInt8 = new UnsignedInt8((short)n);
            }
            if (vector2.size() == 0) {
                vector2.setSize(13);
            }
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt8), 0);
                vector2.setElementAt(new CIMValue((Object)unsignedInt82), 1);
                vector2.setElementAt(new CIMValue((Object)unsignedInt83), 2);
                vector2.setElementAt(new CIMValue((Object)unsignedInt84), 3);
                vector2.setElementAt(new CIMValue((Object)unsignedInt85), 4);
                vector2.setElementAt(new CIMValue((Object)unsignedInt86), 5);
                vector2.setElementAt(new CIMValue((Object)unsignedInt87), 6);
                vector2.setElementAt(new CIMValue(vector3, new CIMDataType(29)), 7);
                vector2.setElementAt(new CIMValue(vector4, new CIMDataType(21)), 8);
                vector2.setElementAt(new CIMValue(vector5, new CIMDataType(23)), 9);
                vector2.setElementAt(new CIMValue(vector6, new CIMDataType(23)), 10);
                vector2.setElementAt(new CIMValue(vector7, new CIMDataType(23)), 11);
                vector2.setElementAt(new CIMValue(vector8, new CIMDataType(23)), 12);
            } else {
                vector2.setElementAt(new CIMProperty(RETURN_CODE, new CIMValue((Object)unsignedInt8)), 0);
                vector2.setElementAt(new CIMProperty("ErrorData", new CIMValue((Object)unsignedInt82)), 1);
                vector2.setElementAt(new CIMProperty("BPASide", new CIMValue((Object)unsignedInt83)), 2);
                vector2.setElementAt(new CIMProperty("SystemStatusMode", new CIMValue((Object)unsignedInt84)), 3);
                vector2.setElementAt(new CIMProperty("SystemStatusProgress", new CIMValue((Object)unsignedInt85)), 4);
                vector2.setElementAt(new CIMProperty("NoOfFRUCompleted", new CIMValue((Object)unsignedInt86)), 5);
                vector2.setElementAt(new CIMProperty("NoOfFRUToLoad", new CIMValue((Object)unsignedInt87)), 6);
                vector2.setElementAt(new CIMProperty("LocationCode", new CIMValue(vector3, new CIMDataType(29))), 7);
                vector2.setElementAt(new CIMProperty("FruStatus", new CIMValue(vector4, new CIMDataType(21))), 8);
                vector2.setElementAt(new CIMProperty("ActualCodeLevel1", new CIMValue(vector5, new CIMDataType(23))), 9);
                vector2.setElementAt(new CIMProperty("ExpectedCodeLevel1", new CIMValue(vector6, new CIMDataType(23))), 10);
                vector2.setElementAt(new CIMProperty("ActualCodeLevel2", new CIMValue(vector7, new CIMDataType(23))), 11);
                vector2.setElementAt(new CIMProperty("ExpectedCodeLevel2", new CIMValue(vector8, new CIMDataType(23))), 12);
            }
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (Throwable throwable) {
            Trace.trace("apcuhscT", "<- FlashUtils.startACDL");
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._FrameClassLogInfo);
            throw new PIHscServerException("3361", throwable);
        }
    }
}

